// Autor: Ante Derek

#include <iostream>
#include <string>
#include <stack>
#include <algorithm>
#include <sstream>

using namespace std;

int main() {
  int n;
  cin >> n;

  stack<pair<int, int> > context;
  vector<int> sol(26, 0);
  int multiplier = 1;

  for (int k=0; k<n; k++) {
    string line;
    cin >> line;
    int indent = count(line.begin(), line.end(), '.');
    while (!context.empty() && context.top().first >= indent) {
      multiplier /= context.top().second;
      context.pop();
    }
    if (line[indent] == 'P')
      sol[line[indent+1]-'a'] += multiplier; 
    else {
      int k;
      istringstream(line.substr(indent+1)) >> k;
      context.push({indent, k});
      multiplier *= k;
    }
  }

  for (int i=0; i<26; i++)
    if (sol[i])
      cout << char('a'+i) << " " << sol[i] << endl;

  return 0;
}
